<!DOCTYPE html>
<html lang="<?php if(ICL_LANGUAGE_CODE=='en') { ?>en<?php } elseif(ICL_LANGUAGE_CODE=='de') { ?>de<?php } else { ?>pl<?php } ?>">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, shrink-to-fit=no" />
    <title><?php wp_title( '|', true, 'right' ); ?></title>
		<meta name="keywords" content=" " />


    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo get_template_directory_uri() ?>/favicon/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="<?php echo get_template_directory_uri() ?>/favicon/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo get_template_directory_uri() ?>/favicon/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo get_template_directory_uri() ?>/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo get_template_directory_uri() ?>/favicon/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="<?php echo get_template_directory_uri() ?>/favicon/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="<?php echo get_template_directory_uri() ?>/favicon/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo get_template_directory_uri() ?>/favicon/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_template_directory_uri() ?>/favicon/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192"  href="<?php echo get_template_directory_uri() ?>/favicon/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo get_template_directory_uri() ?>/favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo get_template_directory_uri() ?>/favicon/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo get_template_directory_uri() ?>/favicon/favicon-16x16.png">
    <link rel="manifest" href="<?php echo get_template_directory_uri() ?>/favicon/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="<?php echo get_template_directory_uri() ?>/favicon/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">

    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet" />

    <link rel="preload" href="<?php echo get_template_directory_uri() ?>/style.css" as="style" />


    <link rel="preload" href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-+0n0xVW2eSR5OomGNYDnhzAbDsOXxcvSN1TPprVMTNDbiYZCxYbOOl7+AMvyTG2x" crossorigin="anonymous">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-+0n0xVW2eSR5OomGNYDnhzAbDsOXxcvSN1TPprVMTNDbiYZCxYbOOl7+AMvyTG2x" crossorigin="anonymous">

    
    <script src="<?php echo get_template_directory_uri() ?>/js/jquery.min.js"></script>

    <link rel="stylesheet" href="<?php echo get_template_directory_uri() ?>/style.css" />

		<?php wp_head() ?>

		<meta name="author" content="creationet.eu" />

  </head>
  <body>

  <script>

    function float1() {
      var x = document.getElementById("float1open");
      if (x.className === "float1") {
        x.className += " float1-open";
      } else {
        x.className = "float1";
      }
    }

  </script>
  
  <?php 
    if(ICL_LANGUAGE_CODE=='en') {
      $header_phone=get_field('header_phone','208');
      $header_email=get_field('header_email','208');
      $facebook=get_field('facebook','208');
      $instagram=get_field('instagram','208');
    }
    elseif(ICL_LANGUAGE_CODE=='de') {
      $header_phone=get_field('header_phone','209');
      $header_email=get_field('header_email','209');
      $facebook=get_field('facebook','209');
      $instagram=get_field('instagram','209');
    } else {
      $header_phone=get_field('header_phone','54');
      $header_email=get_field('header_email','54');
      $facebook=get_field('facebook','54');
      $instagram=get_field('instagram','54');
    }    
  ?>

  <header id="myHeader" class="<?php if ( is_front_page() ) { ?>header-mainpage<?php } elseif( is_home() ) { ?>header-subpage<?php } else { ?>header-subpage<?php } ?><?php if( $header_color == 'image' ) { ?> header-white<?php } ?>">
    <a class="top-brand" href="<?php echo site_url(); ?>">
      <img class="lazy" data-src="<?php echo get_template_directory_uri() ?>/images/kerson.svg" title="" alt="" />
    </a>
    <nav class="topnav" id="Topnavi">
      <a href="javascript:void(0);" class="nav-icon burger" onclick="navi()">
        <div></div>
      </a>
      <?php
          wp_nav_menu( array(
            'theme_location' => 'Main menu',
            'menu' 	  		  => 'Main menu',
            'container'      => 'ul',
            'menu_class'     => 'main-menu',
            'depth'          => 0)
          );
      ?>
      <?php if( $header_phone || $header_email ) { ?>
        <ul class="header-contact">
          <?php if( $header_phone ) { ?>
            <li><a href="tel:<?php echo $header_phone; ?>"><?php echo $header_phone; ?></a></li>
          <?php } ?>
          <?php if( $header_email ) { ?>
            <li><a href="mailto:<?php echo $header_email; ?>"><?php echo $header_email; ?></a></li>
          <?php } ?>
        </ul>
      <?php } ?>
      <?php do_action('wpml_add_language_selector'); ?>
      <?php if( $facebook || $instagram ) { ?>
        <ul class="header-socials">
          <?php if( $instagram ) { ?>
            <li>
              <a href="<?php echo $instagram; ?>" target="_blank">
                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40.008" viewBox="0 0 40 40.008">
                  <g id="instagram" transform="translate(0.07 0.038)">
                    <path id="Path_1431" data-name="Path 1431" d="M2.539,2.739C-.6,5.995.046,9.453.046,19.96c0,8.725-1.522,17.471,6.445,19.53,2.488.64,24.531.64,27.015,0,3.317-.856,6.016-3.546,6.385-8.238.052-.655.052-21.912,0-22.58-.392-5-3.468-7.877-7.522-8.461C31.439.074,31.253.034,26.487.025,9.581.034,5.875-.719,2.539,2.739Z" transform="translate(0 0)" />
                    <path id="Path_1432" data-name="Path 1432" d="M19.964,3.147c-6.894,0-13.44-.613-15.94,5.8-1.033,2.65-.883,6.091-.883,11.018,0,4.324-.139,8.387.883,11.016,2.495,6.419,9.094,5.8,15.936,5.8,6.6,0,13.408.687,15.938-5.8,1.035-2.676.883-6.066.883-11.016,0-6.571.363-10.813-2.825-14-3.228-3.227-7.592-2.822-14-2.822ZM18.456,6.178c14.38-.023,16.21-1.621,15.2,20.58-.359,7.852-6.339,6.99-13.69,6.99-13.4,0-13.789-.383-13.789-13.789C6.176,6.4,7.24,6.185,18.456,6.174ZM28.944,8.97a2.018,2.018,0,1,0,2.018,2.018A2.018,2.018,0,0,0,28.944,8.97Zm-8.98,2.359A8.637,8.637,0,1,0,28.6,19.967a8.639,8.639,0,0,0-8.636-8.638Zm0,3.031c7.414,0,7.423,11.213,0,11.213S12.54,14.36,19.964,14.36Z" transform="translate(0)" fill="#fff"/>
                  </g>
                </svg>
                <span>Instagram</span>
              </a>
            </li>
          <?php } ?>
          <?php if( $facebook ) { ?>
            <li>
              <a href="<?php echo $facebook; ?>" target="_blank">
                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40">
                  <path id="facebook" d="M34.612,0H5.392A5.39,5.39,0,0,0,0,5.39V34.61A5.39,5.39,0,0,0,5.392,40H19.8l.025-14.294H16.114a.876.876,0,0,1-.876-.873l-.018-4.608a.876.876,0,0,1,.876-.88H19.8V14.894c0-5.167,3.155-7.98,7.764-7.98h3.782a.876.876,0,0,1,.876.876v3.885a.876.876,0,0,1-.876.876H29.029c-2.506,0-2.992,1.191-2.992,2.939v3.854h5.508a.876.876,0,0,1,.87.979l-.546,4.608a.876.876,0,0,1-.87.773H26.062L26.037,40h8.575A5.39,5.39,0,0,0,40,34.61V5.39A5.39,5.39,0,0,0,34.612,0Z" transform="translate(-0.002)" />
                </svg>
                <span>Facebook</span>
              </a>
            </li>
          <?php } ?>
        </ul>
      <?php } ?>
    </nav>
  </header>

  <div class="header-pad <?php if ( is_front_page() ) { ?>header-pad-mainpage<?php } elseif( is_home() ) { ?>header-pad-subpage<?php } else { ?>header-pad-subpage<?php } ?>"></div>


<script>
  function navi() {
    var x = document.getElementById("Topnavi");
    if (x.className === "topnav") {
      x.className += " responsive";
    } else {
      x.className = "topnav";
    }
  }
</script>
